/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.commandemulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class CommandEmulator {
    public static final String TYPE_BINARY_CONFIGURATION_SET = "BinaryConfigurationSet";
    public static final String TYPE_XML_CONFIGURATION_SET = "XMLConfigurationSet";
    public static final String DEFAULT_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><configuration>  <CommandEmulator>    <setting name=\"Source Emulator Plugin Path\" type=\"string\">StarLineModeSE</setting>    <setting name=\"Target Converter Plugin Path\" type=\"string\">StarTSPTC</setting>  </CommandEmulator>  <StarLineModeSE>    <Defaults>      <setting name=\"Max Printable Width\" type=\"string\">72mm</setting>    </Defaults>  </StarLineModeSE>  <StarTSPTC>    <setting name=\"Model\" type=\"string\">TSP100</setting>    <setting name=\"Paper Width\" type=\"string\">76mm</setting>  </StarTSPTC></configuration>";
    private long m_commandEmulator;
    private static boolean s_classServicesReadied;
    private static final String s_pluginDirPath;

    public CommandEmulator(String configDataType, byte[] configData) throws Exception {
        if (!s_classServicesReadied) {
            throw new Exception("The required native libraries  & class services are not available.");
        }
        if (configDataType == null || configData == null) {
            throw new NullPointerException("The 'configDataType' and 'configData' parameters must not be null");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                CommandEmulator.this.dispose();
            }
        });
        this.m_commandEmulator = CommandEmulator.native_CommandEmulator_create(configDataType.getBytes(), configData, s_pluginDirPath.getBytes());
    }

    public CommandEmulator(String filePath) throws Exception {
        if (!s_classServicesReadied) {
            throw new Exception("The required native libraries & class services are not available.");
        }
        if (filePath == null) {
            throw new NullPointerException("The 'filePath' parameter must not be null");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                CommandEmulator.this.dispose();
            }
        });
        this.m_commandEmulator = CommandEmulator.native_CommandEmulator_create(filePath.getBytes(), s_pluginDirPath.getBytes());
    }

    public byte[] emulate(byte[] data, int size) throws Exception {
        if (this.m_commandEmulator == 0L) {
            throw new Exception("This instance has already been disposed");
        }
        if (data == null) {
            throw new NullPointerException("The 'data' parameter must not be null");
        }
        return CommandEmulator.native_CommandEmulator_emulate(this.m_commandEmulator, data, size);
    }

    public void dispose() {
        if (this.m_commandEmulator != 0L) {
            CommandEmulator.native_CommandEmulator_destroy(this.m_commandEmulator);
            this.m_commandEmulator = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static final native long native_CommandEmulator_create(byte[] var0, byte[] var1) throws UnsatisfiedLinkError, UnknownError, Exception;

    private static final native long native_CommandEmulator_create(byte[] var0, byte[] var1, byte[] var2) throws UnsatisfiedLinkError, UnknownError, Exception;

    private static final native byte[] native_CommandEmulator_emulate(long var0, byte[] var2, int var3) throws UnknownError, Exception;

    private static final native void native_CommandEmulator_destroy(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isInstalledResourceBinarySame(String installPath, String resourcePath) {
        InputStream installedStream = null;
        InputStream resourceStream = null;
        try {
            installedStream = new FileInputStream(new File(installPath));
            byte[] buf1 = new byte[10240];
            resourceStream = CommandEmulator.class.getClassLoader().getResource(resourcePath).openStream();
            byte[] buf2 = new byte[10240];
            block32: while (true) {
                int len1;
                if ((len1 = installedStream.read(buf1)) <= 0) {
                    boolean bl;
                    if (resourceStream.read(buf2) > 0) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                int buf1Idx = 0;
                while (true) {
                    int i;
                    if (len1 <= 0) continue block32;
                    int len2 = resourceStream.read(buf2, 0, len1);
                    if (len2 <= 0) {
                        i = 0;
                        return i != 0;
                    }
                    len1 -= len2;
                    for (i = 0; i < len2; ++i) {
                        if (buf1[buf1Idx + i] == buf2[i]) continue;
                        boolean bl = false;
                        return bl;
                    }
                    buf1Idx += len2;
                }
                break;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (installedStream != null) {
                    installedStream.close();
                }
            }
            catch (Exception e) {}
            try {
                if (resourceStream != null) {
                    resourceStream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void installResource(String installPath, String resourcePath) throws Exception {
        InputStream resourceStream = null;
        OutputStream installStream = null;
        try {
            int len;
            resourceStream = CommandEmulator.class.getClassLoader().getResource(resourcePath).openStream();
            File installFile = new File(installPath);
            String installDirectory = installFile.getParent();
            if (installDirectory != null) {
                new File(installDirectory).mkdirs();
            }
            installFile.delete();
            installFile.createNewFile();
            installStream = new FileOutputStream(installFile);
            byte[] buf = new byte[10240];
            while ((len = resourceStream.read(buf)) > 0) {
                installStream.write(buf, 0, len);
            }
        }
        finally {
            if (resourceStream != null) {
                resourceStream.close();
            }
            if (installStream != null) {
                installStream.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("-version")) {
            System.out.println("CommandEmulator: version 20061106");
            return;
        }
        try {
            int available;
            CommandEmulator commandEmulator = args.length == 1 ? new CommandEmulator(args[0]) : new CommandEmulator(TYPE_XML_CONFIGURATION_SET, DEFAULT_CONFIG.getBytes());
            byte[] buffer = new byte[1024];
            while ((available = System.in.read(buffer)) != -1) {
                byte[] targetData = commandEmulator.emulate(buffer, available);
                if (targetData == null) continue;
                System.out.write(targetData);
            }
        }
        catch (Exception e) {
            System.err.println("CommandEmulator: failure");
            e.printStackTrace();
        }
    }

    static {
        try {
            String pluginDirPath = System.getProperty("user.home") + "/.commandemulator/";
            String osname = System.getProperty("os.name");
            String[] supportingLibraries = osname.indexOf("Windows") >= 0 ? new String[]{"xerces-c_2_7", "Configuration", "CommandEmulator", "TargetAction", "GenericAction", "StarLineModeSE", "StarTSPTC", "CropGAF", "MergeGAF", "WallMountGAF", "CmdSubPP", "AddImageGAF"} : new String[]{"Configuration", "CommandEmulator", "TargetAction", "GenericAction", "StarLineModeSE", "StarTSPTC", "CropGAF", "MergeGAF", "WallMountGAF", "CmdSubPP", "AddImageGAF"};
            for (int i = 0; i < supportingLibraries.length; ++i) {
                String mappedLibraryName = System.mapLibraryName(supportingLibraries[i]);
                if (!CommandEmulator.isInstalledResourceBinarySame(pluginDirPath + mappedLibraryName, "com/starmicronics/commandemulator/resources/" + mappedLibraryName)) {
                    CommandEmulator.installResource(pluginDirPath + mappedLibraryName, "com/starmicronics/commandemulator/resources/" + mappedLibraryName);
                }
                if (osname.indexOf("Windows") < 0) continue;
                Runtime.getRuntime().load(pluginDirPath + mappedLibraryName);
            }
            String[] jniLibraries = new String[]{"CommandEmulatorJ"};
            for (int i = 0; i < jniLibraries.length; ++i) {
                String mappedLibraryName = System.mapLibraryName(jniLibraries[i]);
                if (!CommandEmulator.isInstalledResourceBinarySame(pluginDirPath + mappedLibraryName, "com/starmicronics/commandemulator/resources/" + mappedLibraryName)) {
                    CommandEmulator.installResource(pluginDirPath + mappedLibraryName, "com/starmicronics/commandemulator/resources/" + mappedLibraryName);
                }
                Runtime.getRuntime().load(pluginDirPath + mappedLibraryName);
            }
            s_classServicesReadied = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            s_classServicesReadied = false;
        }
        s_pluginDirPath = System.getProperty("user.home") + "/.commandemulator/";
    }
}

